<?php
/**
 * Single Product
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */
?>
<div class="wrap-content" role="main">
    <div class="container">
        <?php
        // Start the loop.
        while ( have_posts() ) : the_post();?>
            <div class="entry-header clearfix">
                <header class="entry-header-title">
                    <?php  the_title( '<h1 class="entry-title">', '</h1>' ); ?>
                </header>
                <!-- .entry-header -->
                <?php nerubian_excerpt(); ?>

                <?php if(get_theme_mod('nerubian_avatar_meta',true)):?>
                    <div class="entry-avatar clearfix">
                        <?php
                        $author_bio_avatar_size = apply_filters( 'buggy_author_bio_avatar_size', 45 );
                        echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
                        ?>

                        <div class="avatar-meta">
                            <span class="author-title">
                                <a class="author-link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
                                    <?php echo esc_attr(get_the_author()); ?>
                                </a>
                            </span>
                            <span class="post-date">
                                <?php if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
                                    $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

                                    if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
                                        $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
                                    }

                                    $time_string = sprintf( $time_string,
                                        esc_attr( get_the_date( 'c' ) ),
                                        get_the_date(),
                                        esc_attr( get_the_modified_date( 'c' ) ),
                                        get_the_modified_date()
                                    );

                                    printf( '<span class="posted-on"><span class="screen-reader-text">%1$s </span><a href="%2$s" rel="bookmark">%3$s</a></span>',
                                        _x( 'Posted on', 'Used before publish date.', 'nerubian' ),
                                        esc_url( get_permalink() ),
                                        $time_string
                                    );
                                }
                                ?>
                            </span>
                        </div>
                    </div>
                <?php endif;?>
            </div>
        <?php endwhile; ?>

        <div class="row single-main-content">
            <div class="main-content content-right col-sx-12 col-sm-12 col-md-9 col-lg-9">
                <div class="content-inner">
                    <?php
                    // Start the loop.
                    while ( have_posts() ) : the_post();
                        get_template_part( 'content','single' );
                        // End the loop.
                    endwhile;
                    ?>
                </div>
            </div>
            <div id="archive-sidebar" class="sidebar sidebar-right col-sx-12 col-sm-12 col-md-3 col-lg-3 archive-sidebar single-sidebar">
                <?php if(is_active_sidebar( 'single')){
                    dynamic_sidebar('single');
                }?>
            </div>

        </div><!-- .content-area -->
        <?php
        //ads
        if(get_theme_mod('nerubian_ads_single_bottom')) {?>
            <div class="advertising_single_bottom">
                <?php echo  wp_kses_post(get_theme_mod('nerubian_ads_bottom'));?>
            </div>
        <?php }?>

    </div>
</div>
